#!/bin/bash

set -e

echo "==> Установка необходимых пакетов..."
apt update
apt install -y python3 python3-venv python3-pip nginx sudo iptables

echo "==> Распаковка panel.tar в /opt..."
tar -xf ./panel.tar -C /opt
echo "==> Распаковка mediamtx.tar в /opt..."
tar -xf ./mediamtx.tar -C /opt

echo "==> Установка прав на директории и файлы..."
chown -R root:root /opt/panel
chown -R root:root /opt/mediamtx
chmod -R 755 /opt/panel
chmod -R 755 /opt/mediamtx

echo "==> Установка backend-зависимостей..."
cd /opt/panel/backend
python3 -m venv venv
source venv/bin/activate
pip install --upgrade pip
pip install -r requirements.txt

echo "==> Создание systemd unit-файлов..."

install -m 644 <(echo "[Unit]
Description=MediaMTX Server
After=network.target

[Service]
ExecStart=/opt/mediamtx/mediamtx /opt/mediamtx/mediamtx.yml
WorkingDirectory=/opt/mediamtx
Restart=always
RestartSec=5s
StartLimitInterval=30s
StartLimitBurst=3
LimitNOFILE=8192

[Install]
WantedBy=multi-user.target
") /etc/systemd/system/mediamtx.service

install -m 644 <(echo "[Unit]
Description=MediaMTX Videowall Server
After=network.target

[Service]
ExecStart=/opt/mediamtx/mediamtx /opt/panel/data/mediamtx_videowall/mediamtx_wall.yml
WorkingDirectory=/opt/mediamtx
Restart=always
RestartSec=5s
StartLimitInterval=30s
StartLimitBurst=3
LimitNOFILE=8192

[Install]
WantedBy=multi-user.target
") /etc/systemd/system/mediamtx_wall.service

install -m 644 <(echo "[Unit]
Description=MediaMTX Panel (Backend + Frontend)
After=network.target

[Service]
Type=simple
WorkingDirectory=/opt/panel/backend
ExecStart=/bin/bash -c \"source /opt/panel/backend/venv/bin/activate && uvicorn app:app --host 0.0.0.0 --port 8000\"
Restart=always
Environment=PYTHONUNBUFFERED=1

[Install]
WantedBy=multi-user.target
") /etc/systemd/system/mediamtx_panel.service

echo "==> Перезапуск systemd и запуск сервисов..."
systemctl daemon-reload
systemctl enable mediamtx.service
systemctl enable mediamtx_wall.service
systemctl enable mediamtx_panel.service
systemctl restart mediamtx.service
systemctl restart mediamtx_wall.service
systemctl restart mediamtx_panel.service

echo "==> Настройка nginx..."

install -m 644 <(cat <<'NGINX'
server {
    listen 80;
    server_name _;

    root /opt/panel/frontend/build;
    index index.html;

    location /panel/ {
        proxy_pass http://127.0.0.1:8000/;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
    }

    location / {
        try_files $uri /index.html;
    }
}
NGINX
) /etc/nginx/sites-available/mediamtx-panel

ln -sf /etc/nginx/sites-available/mediamtx-panel /etc/nginx/sites-enabled/mediamtx-panel
rm -f /etc/nginx/sites-enabled/default
sudo nginx -t && systemctl reload nginx

echo "==> Установка завершена успешно!"