# Backend API for MediaMTX Panel Application

Backend реализован на FastAPI и предоставляет API для управления потоками, пользователями, видеостеной, firewall и сервисами.

## Запуск

1. Клонируйте репозиторий и перейдите в папку backend:
   ```bash
   git clone <repository-url>
   cd mediamtx-panel-app/backend
   ```

2. (Рекомендуется) Создайте виртуальное окружение:
   ```bash
   apt install python3.11-venv
   python3 -m venv venv
   source venv/bin/activate
   ```

3. Установите зависимости:
   ```bash
   pip install -r requirements.txt
   ```

4. Запустите FastAPI-приложение:
   ```bash
   uvicorn app:app --reload
   ```

   API будет доступен по адресу `http://127.0.0.1:8000`.

## Основные API эндпоинты

- **/streams** — управление потоками (GET, POST, PUT, DELETE)
- **/videowall** — профили и состояние видеостены
- **/firewall** — правила iptables, политики по умолчанию, сохранение состояния
- **/service** — управление сервисами, резервные копии, системная статистика
- **/users** — управление пользователями

Примеры запросов:

### Получить список потоков

```bash
curl -X GET http://127.0.0.1:8000/streams
```

### Создать поток

```bash
curl -X POST http://127.0.0.1:8000/streams -H "Content-Type: application/json" -d '{"name": "New Stream", "source": "rtsp://example.com/stream"}'
```

### Создать резервную копию

```bash
curl -X POST http://127.0.0.1:8000/service/backups/create
```

## Лицензия

Проект распространяется под лицензией MIT. Подробнее см. файл LICENSE.